/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.rasterization;

import com.moulberry.axiom.rasterization.Rasterization3D;
import com.moulberry.axiom.rasterization.RasterizationHelper;
import com.moulberry.axiomclientapi.funcinterfaces.TriIntConsumer;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3i;

public class DiskRasterization {
    public static void disk(Vector3i center, int diameterX, int diameterZ, boolean hollow, Quaternionf quaternionf, TriIntConsumer consumer) {
        if (diameterX <= 0 || diameterZ <= 0) {
            return;
        }
        int centerX = center.x;
        int centerY = center.y;
        int centerZ = center.z;
        float radiusX = (float)(diameterX - 1) / 2.0f;
        float radiusZ = (float)(diameterZ - 1) / 2.0f;
        if (hollow) {
            float offsetX = radiusX % 1.0f + 0.5f;
            float offsetZ = radiusZ % 1.0f + 0.5f;
            Vector3f from = new Vector3f(offsetX, 0.5f, radiusZ - 0.15f + offsetZ);
            quaternionf.transformInverse(from);
            Vector3f to = new Vector3f();
            for (int a = 0; a <= 360; ++a) {
                float currX = (float)Math.sin(Math.toRadians(a)) * (radiusX - 0.15f) + offsetX;
                float currZ = (float)Math.cos(Math.toRadians(a)) * (radiusZ - 0.15f) + offsetZ;
                to.set(currX, 0.5f, currZ);
                quaternionf.transformInverse(to);
                Rasterization3D.dda(from, to, (x, y, z) -> consumer.accept(x + centerX, y + centerY, z + centerZ));
                Vector3f temp = from;
                from = to;
                to = temp;
            }
        } else {
            float invRadiusSqX = RasterizationHelper.calcInvRadiusSq(radiusX);
            float invRadiusSqZ = RasterizationHelper.calcInvRadiusSq(radiusZ);
            RasterizationHelper.planeCondition(center, diameterX, diameterZ, quaternionf, (x, y) -> x * x * invRadiusSqX + y * y * invRadiusSqZ <= 1.0f, consumer);
        }
    }
}

